/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yuushya.registries.YuushyaRegistryData;
import java.util.Map;

public class GsonTools {
    public static final Gson NormalGSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();

    public static void extendJsonObject(JsonObject destinationObject, ConflictStrategy conflictResolutionStrategy, JsonObject ... objs) throws JsonObjectExtensionConflictException {
        for (JsonObject obj : objs) {
            GsonTools.extendJsonObject(destinationObject, obj, conflictResolutionStrategy);
        }
    }

    private static void extendJsonObject(JsonObject leftObj, JsonObject rightObj, ConflictStrategy conflictStrategy) throws JsonObjectExtensionConflictException {
        for (Map.Entry rightEntry : rightObj.entrySet()) {
            String rightKey = (String)rightEntry.getKey();
            JsonElement rightVal = (JsonElement)rightEntry.getValue();
            if (leftObj.has(rightKey)) {
                JsonElement leftVal = leftObj.get(rightKey);
                if (leftVal.isJsonArray() && rightVal.isJsonArray()) {
                    JsonArray leftArr = leftVal.getAsJsonArray();
                    JsonArray rightArr = rightVal.getAsJsonArray();
                    for (int i = 0; i < rightArr.size(); ++i) {
                        leftArr.add(rightArr.get(i));
                    }
                    continue;
                }
                if (leftVal.isJsonObject() && rightVal.isJsonObject()) {
                    GsonTools.extendJsonObject(leftVal.getAsJsonObject(), rightVal.getAsJsonObject(), conflictStrategy);
                    continue;
                }
                GsonTools.handleMergeConflict(rightKey, leftObj, leftVal, rightVal, conflictStrategy);
                continue;
            }
            leftObj.add(rightKey, rightVal);
        }
    }

    public static YuushyaRegistryData.Block combineYuushyaDataBlockJson(JsonObject blockJson, JsonObject templateBlockJson) {
        try {
            GsonTools.extendJsonObject(blockJson, ConflictStrategy.PREFER_SECOND_OBJ, templateBlockJson);
        }
        catch (JsonObjectExtensionConflictException e) {
            e.printStackTrace();
        }
        return (YuushyaRegistryData.Block)NormalGSON.fromJson((JsonElement)blockJson, YuushyaRegistryData.Block.class);
    }

    private static void handleMergeConflict(String key, JsonObject leftObj, JsonElement leftVal, JsonElement rightVal, ConflictStrategy conflictStrategy) throws JsonObjectExtensionConflictException {
        switch (conflictStrategy) {
            case PREFER_FIRST_OBJ: {
                break;
            }
            case PREFER_SECOND_OBJ: {
                leftObj.add(key, rightVal);
                break;
            }
            case PREFER_NON_NULL: {
                if (!leftVal.isJsonNull() || rightVal.isJsonNull()) break;
                leftObj.add(key, rightVal);
                break;
            }
            case THROW_EXCEPTION: {
                throw new JsonObjectExtensionConflictException("Key " + key + " exists in both objects and the conflict resolution strategy is " + conflictStrategy);
            }
            default: {
                throw new UnsupportedOperationException("The conflict strategy " + conflictStrategy + " is unknown and cannot be processed");
            }
        }
    }

    public static enum ConflictStrategy {
        THROW_EXCEPTION,
        PREFER_FIRST_OBJ,
        PREFER_SECOND_OBJ,
        PREFER_NON_NULL;

    }

    public static class JsonObjectExtensionConflictException
    extends Exception {
        public JsonObjectExtensionConflictException(String message) {
            super(message);
        }
    }
}

